package com.hero.ui.dialog;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.CustomPower;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CustomPowerDialog extends PowerDialog {
	private static final long serialVersionUID = -3772005866139357739L;

	protected CustomPower custompower;

	protected JLabel rangeLbl;

	protected JLabel durationLbl;

	protected JLabel targetLbl;

	protected JCheckBox usesENDCB;

	protected JCheckBox visibleCB;

	protected JComboBox rangeCombo;

	protected JComboBox durationCombo;

	protected JComboBox targetCombo;

	protected JLabel endSourceLbl;

	protected JComboBox endSourceCombo;

	protected JCheckBox doesBODYCB;

	protected JCheckBox doesDamageCB;

	protected JCheckBox doesKnockbackCB;

	protected JCheckBox killingCB;

	protected JLabel defenseLbl;

	protected JComboBox defenseCombo;

	protected JCheckBox useCustomColumn3CB;

	protected JLabel customColumn3Lbl;

	protected JTextField customColumn3TF;

	public CustomPowerDialog(CustomPower pow, boolean isNew, boolean isPower) {
		super(pow, isNew, isPower, false);
		custompower = pow;
		init();
	}

	@Override
	protected JPanel getTopPanel() {
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);

		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridwidth = 3;
		gbc.weightx = 0;
		equipmentPanel.add(carriedCB, gbc);
		gbc.gridy++;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridwidth = 1;
		equipmentPanel.add(weightLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		equipmentPanel.add(weightTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 1;
		equipmentPanel.add(new JLabel(HeroDesigner.getInstance().getPrefs()
				.isMetric() ? "kg" : "lbs"), gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = 0;
		equipmentPanel.add(priceLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		if (HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix()) {
			gbc.gridwidth = 2;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.insets = new Insets(2, 0, 5, 2);
			JPanel pricePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
			pricePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
			pricePanel.add(new JLabel(HeroDesigner.getActiveHero().getRules()
					.getEquipmentCostUnits()));
			pricePanel.add(priceTF);
			equipmentPanel.add(pricePanel, gbc);
			gbc.insets = new Insets(2, 5, 5, 2);
		} else {
			gbc.gridwidth = 2;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.insets = new Insets(2, 0, 5, 2);
			JPanel pricePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
			pricePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
			pricePanel.add(priceTF);
			pricePanel.add(new JLabel(HeroDesigner.getActiveHero().getRules()
					.getEquipmentCostUnits()));
			equipmentPanel.add(pricePanel, gbc);
			gbc.insets = new Insets(2, 5, 5, 2);
		}
		equipmentPanel.setBorder(BorderFactory
				.createTitledBorder("Equipment Info."));

		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);

		JPanel panel = new JPanel(new GridBagLayout());
		panel.add(nameLbl, gbc);
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridwidth = 2;
		panel.add(nameTF, gbc);
		gbc.gridy = 20;
		gbc.gridwidth = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridx = 0;
		panel.add(displayLbl, gbc);
		gbc.gridy = 25;
		if (object.getOptions().size() > 0) {
			panel.add(optionsLbl, gbc);
		}
		gbc.gridy = 30;
		panel.add(levelsLbl, gbc);
		gbc.gridy = 37;
		panel.add(endSourceLbl, gbc);
		gbc.gridy = 40;
		panel.add(rangeLbl, gbc);
		gbc.gridy = 41;
		panel.add(durationLbl, gbc);
		gbc.gridy = 42;
		panel.add(targetLbl, gbc);
		gbc.gridy = 43;
		panel.add(defenseLbl, gbc);
		gbc.gridy = 20;
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = 2;
		panel.add(displayTF, gbc);
		gbc.gridy = 25;
		if (object.getOptions().size() > 0) {
			panel.add(optionsCB, gbc);
		}
		gbc.gridy = 30;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(levelTF, gbc);
		gbc.gridy = 31;
		panel.add(usesENDCB, gbc);
		gbc.gridy = 32;
		panel.add(useCustomColumn3CB, gbc);
		JPanel customPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		customPanel.add(customColumn3Lbl);
		customPanel.add(customColumn3TF);
		gbc.gridy = 33;
		panel.add(customPanel, gbc);
		gbc.gridy = 34;
		panel.add(visibleCB, gbc);
		gbc.gridy = 35;
		panel.add(doesDamageCB, gbc);
		gbc.gridy = 36;
		panel.add(doesBODYCB, gbc);
		gbc.gridy = 37;
		panel.add(killingCB, gbc);
		gbc.gridy = 38;
		panel.add(doesKnockbackCB, gbc);
		gbc.gridy = 39;
		panel.add(endSourceCombo, gbc);
		gbc.gridy = 40;
		panel.add(rangeCombo, gbc);
		gbc.gridy = 41;
		panel.add(durationCombo, gbc);
		gbc.gridy = 42;
		panel.add(targetCombo, gbc);
		gbc.gridy = 43;
		panel.add(defenseCombo, gbc);
		if (object.isUserInput()) {
			gbc.gridy = 44;
			gbc.gridx = 0;
			gbc.gridwidth = 1;
			gbc.anchor = GridBagConstraints.EAST;
			gbc.fill = GridBagConstraints.NONE;
			gbc.weightx = 0;
			panel.add(inputLbl, gbc);
			gbc.gridx = 1;
			gbc.fill = GridBagConstraints.HORIZONTAL;
			gbc.weightx = 1;
			gbc.gridwidth = 2;
			panel.add(exampleCombo, gbc);
		}

		gbc.gridwidth = 1;
		gbc.gridx = 0;
		gbc.gridy = 84;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.anchor = GridBagConstraints.EAST;
		panel.add(quantityLbl, gbc);
		gbc.gridx = 1;
		gbc.gridwidth = 2;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(quantityTF, gbc);

		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridwidth = 1;
		gbc.weightx = 0;
		gbc.gridy = 99;
		gbc.gridx = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		if (object.isEquipment()) {
			panel.add(equipmentPanel, gbc);
		}
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		doesBODYCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				custompower.setDoesBODY(doesBODYCB.isSelected());
			}
		});
		doesDamageCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				custompower.setDoesDamage(doesDamageCB.isSelected());
				doesBODYCB.setEnabled(doesDamageCB.isSelected());
				killingCB.setEnabled(doesDamageCB.isSelected());
			}
		});
		doesKnockbackCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				custompower.setDoesKnockback(doesKnockbackCB.isSelected());
			}
		});
		killingCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				custompower.setKilling(killingCB.isSelected());
			}
		});
		defenseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				custompower.setDefense(defenseCombo.getSelectedItem()
						.toString().toUpperCase());
			}
		});
		visibleCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				custompower.setVisible(visibleCB.isSelected());
			}
		});
		usesENDCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				custompower.usesEnd(usesENDCB.isSelected());
				boolean use = useCustomColumn3CB.isSelected();
				useCustomColumn3CB.setEnabled(!usesENDCB.isSelected());
				customColumn3TF.setEnabled(use && !usesENDCB.isSelected());
				customColumn3Lbl.setEnabled(use && !usesENDCB.isSelected());
				updateValues();
			}
		});
		endSourceCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				custompower
						.setUseENDReserve(endSourceCombo.getSelectedIndex() == 1);
			}
		});
		rangeCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (rangeCombo.getSelectedIndex() == 0) {
					custompower.setRange("SELF");
				} else if (rangeCombo.getSelectedIndex() == 1) {
					custompower.setRange("NO");
				} else if (rangeCombo.getSelectedIndex() == 2) {
					custompower.setRange("YES");
				} else if (rangeCombo.getSelectedIndex() == 3) {
					custompower.setRange("LOS");
				}
			}
		});
		durationCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (durationCombo.getSelectedIndex() == 0) {
					custompower.setDuration("INSTANT");
				} else if (durationCombo.getSelectedIndex() == 1) {
					custompower.setDuration("CONSTANT");
				} else if (durationCombo.getSelectedIndex() == 2) {
					custompower.setDuration("PERSISTENT");
				} else if (durationCombo.getSelectedIndex() == 3) {
					custompower.setDuration("INHERENT");
				}
			}
		});
		targetCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (targetCombo.getSelectedIndex() == 0) {
					custompower.setTarget("N/A");
				} else if (targetCombo.getSelectedIndex() == 1) {
					custompower.setTarget("SELFONLY");
				} else if (targetCombo.getSelectedIndex() == 2) {
					custompower.setTarget("DCV");
				} else if (targetCombo.getSelectedIndex() == 3) {
					custompower.setTarget("ECV");
				} else if (targetCombo.getSelectedIndex() == 4) {
					custompower.setTarget("HEX");
				}
			}
		});
		customColumn3TF.getDocument().addDocumentListener(
				new DocumentListener() {
					public void changedUpdate(DocumentEvent e) {
						custompower.setColumn3Output(customColumn3TF.getText());
					}

					public void insertUpdate(DocumentEvent e) {
						custompower.setColumn3Output(customColumn3TF.getText());
					}

					public void removeUpdate(DocumentEvent e) {
						custompower.setColumn3Output(customColumn3TF.getText());
					}
				});
		useCustomColumn3CB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				boolean use = useCustomColumn3CB.isSelected();
				custompower.setUseCustomColumn3(use);
				customColumn3TF.setEnabled(use);
				customColumn3Lbl.setEnabled(use);
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		boolean is6E = HeroDesigner.getActiveTemplate().is6E();
		levelsLbl.setText("Base Cost:");
		rangeLbl = new JLabel("Range:");
		durationLbl = new JLabel("Duration:");
		targetLbl = new JLabel("Target:");
		usesENDCB = new JCheckBox("Uses END");
		usesENDCB.setSelected(custompower.getAPPerEnd() != 0);
		if (HeroDesigner.getActiveTemplate().is6E()) {
			visibleCB = new JCheckBox("Perceivable");
		} else {
			visibleCB = new JCheckBox("Visible");
		}
		visibleCB.setSelected(custompower.isVisible());
		ArrayList<String> rangeOps = new ArrayList<String>();
		if (is6E) {
			rangeOps.add("Self");
		} else {
			rangeOps.add("Self Only");
		}
		rangeOps.add("None");
		rangeOps.add("Ranged");
		rangeOps.add("Line of Sight");
		rangeCombo = new JComboBox(rangeOps.toArray());
		if (custompower.getRange().equals("SELF")) {
			rangeCombo.setSelectedIndex(0);
		} else if (custompower.getRange().toUpperCase().equals("NO")) {
			rangeCombo.setSelectedIndex(1);
		} else if (custompower.getRange().toUpperCase().equals("YES")) {
			rangeCombo.setSelectedIndex(2);
		} else if (custompower.getRange().toUpperCase().equals("LOS")) {
			rangeCombo.setSelectedIndex(3);
		}

		ArrayList<String> durationOps = new ArrayList<String>();
		durationOps.add("Instant");
		durationOps.add("Constant");
		durationOps.add("Persistent");
		durationOps.add("Inherent");
		durationCombo = new JComboBox(durationOps.toArray());
		if (custompower.getDuration().toUpperCase().equals("INSTANT")) {
			durationCombo.setSelectedIndex(0);
		} else if (custompower.getDuration().toUpperCase().equals("CONSTANT")) {
			durationCombo.setSelectedIndex(1);
		} else if (custompower.getDuration().toUpperCase().equals("PERSISTENT")) {
			durationCombo.setSelectedIndex(2);
		} else if (custompower.getDuration().toUpperCase().equals("INHERENT")) {
			durationCombo.setSelectedIndex(3);
		}

		ArrayList<String> targetOps = new ArrayList<String>();
		targetOps.add("N/A");
		targetOps.add("Self Only");
		targetOps.add("DCV");
		if (is6E) {
			targetOps.add("DMCV");
			targetOps.add("Area");
		} else {
			targetOps.add("ECV");
			targetOps.add("HEX");
		}
		targetCombo = new JComboBox(targetOps.toArray());
		if (custompower.getTarget().toUpperCase().equals("N/A")) {
			targetCombo.setSelectedIndex(0);
		} else if (custompower.getTarget().toUpperCase().equals("SELFONLY")) {
			targetCombo.setSelectedIndex(1);
		} else if (custompower.getTarget().toUpperCase().equals("DCV")) {
			targetCombo.setSelectedIndex(2);
		} else if (custompower.getTarget().toUpperCase().equals("ECV")) {
			targetCombo.setSelectedIndex(3);
		} else if (custompower.getTarget().toUpperCase().equals("HEX")) {
			targetCombo.setSelectedIndex(4);
		}

		endSourceLbl = new JLabel("END Source:");
		ArrayList<String> source = new ArrayList<String>();
		source.add("Personal END");
		source.add("END Reserve");
		endSourceCombo = new JComboBox(source.toArray());
		if (custompower.getUseENDReserve()) {
			endSourceCombo.setSelectedIndex(1);
		} else {
			endSourceCombo.setSelectedIndex(0);
		}

		if ((custompower.getEndUsage() == 0)
				|| ((GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") == null) && (GenericObject
						.findObjectByID(HeroDesigner.getActiveHero()
								.getEquipment(), "ENDURANCERESERVE") == null))
				|| (GenericObject.findObjectByID(custompower
						.getAssignedModifiers(), "ENDRESERVEOREND") != null)) {
			endSourceLbl.setVisible(false);
			endSourceCombo.setVisible(false);
		}

		doesDamageCB = new JCheckBox("Does Damage");
		doesDamageCB.setSelected(custompower.doesDamage());
		doesBODYCB = new JCheckBox("Does BODY");
		doesBODYCB.setSelected(custompower.doesBODY());
		doesBODYCB.setEnabled(custompower.doesDamage());
		doesKnockbackCB = new JCheckBox("Does Knockback");
		doesKnockbackCB.setSelected(custompower.doesKnockback());
		killingCB = new JCheckBox("Does Killing Damage");
		killingCB.setSelected(custompower.isKilling());
		killingCB.setEnabled(custompower.doesDamage());

		ArrayList<String> defenses = new ArrayList<String>();
		defenses.add("None");
		defenses.add("Normal");
		defenses.add("Mental");
		defenses.add("Power");
		defenses.add("Flash");
		defenseLbl = new JLabel("Defense:");
		defenseCombo = new JComboBox(defenses.toArray());
		if (custompower.getDefense().equals("NONE")) {
			defenseCombo.setSelectedIndex(0);
		} else if (custompower.getDefense().equals("NORMAL")) {
			defenseCombo.setSelectedIndex(1);
		} else if (custompower.getDefense().equals("MENTAL")) {
			defenseCombo.setSelectedIndex(2);
		} else if (custompower.getDefense().equals("POWER")) {
			defenseCombo.setSelectedIndex(3);
		} else if (custompower.getDefense().equals("FLASH")) {
			defenseCombo.setSelectedIndex(4);
		}

		useCustomColumn3CB = new JCheckBox("Define Custom END Column Output");
		useCustomColumn3CB.setSelected(custompower.useCustomColumn3());
		useCustomColumn3CB.setEnabled(custompower.getAPPerEnd() == 0);
		customColumn3Lbl = new JLabel("END Column Output:");
		customColumn3Lbl.setEnabled(custompower.useCustomColumn3());
		customColumn3TF = new JTextField(custompower.getColumn3Output(), 4);
		customColumn3TF.setEnabled(custompower.useCustomColumn3());
	}

	@Override
	public void updateValues() {
		super.updateValues();
		if ((custompower.getEndUsage() == 0)
				|| ((GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") == null) && (GenericObject
						.findObjectByID(HeroDesigner.getActiveHero()
								.getEquipment(), "ENDURANCERESERVE") == null))
				|| (GenericObject.findObjectByID(custompower
						.getAssignedModifiers(), "ENDRESERVEOREND") != null)) {
			endSourceLbl.setVisible(false);
			endSourceCombo.setVisible(false);
		} else {
			endSourceLbl.setVisible(true);
			endSourceCombo.setVisible(true);
		}
	}
}